''''''''''''''''
'Renaming pages'
''''''''''''''''
function Main as string
Dim Form, CurDoc, CurPage as object
Dim PageName, Msg as string
Dim PageNum, CheckNum as integer
Dim Done as Boolean
const Title = "Renaming pages"

  CurDoc = ActiveDocument
  CurPage = CurDoc.ActivePage
  PageNum = CurDoc.Index(CurPage)
  do
    Form = ReadForm("Rnmpg.frm")
    Form.SetIntValue("PageNumber", PageNum)
    PageName = CurDoc.Item(PageNum).GetName
    do
      Form.SetStrValue("PageName", PageName)
      ' Show form
      if Form.ExecForm Then
        PageNum = Form.GetIntValue("PageNumber")
        PageName = Form.GetStrValue("PageName")
      else
        Main = "Cancelled"
        Exit Function
      end if
      if PageNum > CurDoc.Count then
        Done = False
        Msg = "There is no page " + Str(PageNum) + " in your document." + Chr(13)
        Msg = Msg + "Please correct your commitment and try again"
        MessageBox(Msg, Title, MBB_OK or MBI_EXCLAMATION)
      else
        Done = True
        if Len(PageName) > 40 then
          Msg = "The name is too long." + Chr(13)
          Msg = Msg + "Would you like to use the first 40 symbols?"
          if MessageBox(Msg, Title, MBB_YESNO or MBI_QUESTION) = MBR_YES then
            PageName = Left(PageName, 40)
          else
            Done = False
          end if
        end if
      end if
    loop while not Done

    RenamePage(PageNum, PageName)

    if PageNum >= CurDoc.Count then Exit Do
    Msg = "Do you want to name next page?"
    if MessageBox(Msg, Title, MBB_YESNO or MBI_QUESTION) = MBR_NO then
      Exit Do
    end if
    PageNum = PageNum + 1
  loop while True

  Main = "Completed"

end function

sub RenamePage(PNum as integer, PName as string)
Dim Page as object

  Page = ActiveDocument.Item(PNum)
  Page.SetName(PName)

end sub
